local function simple_rot_spline_demo(notefield)
  -- This assumes dance game mode.  There are 8 entries in column_rots to
  -- make it work in double mode.  The rotations are picked to make all
  -- arrows point down.
  -- Fetching a notefield can be done on gameplay with this:
  -- SCREENMAN:GetTopScreen():GetChild("Player"..ToEnumShortString(pn))
  --   :GetChild("NoteField")
  -- Edit mode names its actors differently, so that doesn't work in edit
  -- mode.  In edit mode, the player actor is simply named "Player".
  -- Docs/Luadoc/Lua.xml has more info on splines.
  local column_rots= {math.pi, math.pi, math.pi, math.pi, math.pi, math.pi, math.pi, math.pi,}
  
  for i, column in ipairs(notefield:get_column_actors()) do
	  
    local rot_handler= column:get_rot_handler()
    -- NoteColumnSplineMode_Position makes the column ignore mods like dizzy,
    -- twirl, and roll, because those also change the note's rotation.
    -- NoteColumnSplineMode_Offset would make it sum the effect of mods and
    -- the spline.
    rot_handler:set_spline_mode("NoteColumnSplineMode_Position")
    local spline= rot_handler:get_spline()
    -- Since the notes don't need to change rotation over time, the spline
    -- has only one point.  That one point sets the x and y rotation to 0,
    -- and fetches the z rotation from the column_rots table.
    spline:set_loop(true):set_size(1):set_point(1, {0, 0, column_rots[i]})
    -- If the spline had more than one point, it would need to be solved to
    -- make the notes smoothly turn.
    -- spline:solve()
  end
end



local AF = Def.ActorFrame {
	InitCommand = function(self)
   		self:sleep(200) -- change this to however long you want stuff to happen (in seconds)
	end,
    OnCommand = function(self)
		local Players = GAMESTATE:GetHumanPlayers()
		
		-- loop through any available human players...
		for player in ivalues(Players) do
			
			-- transform the full player string like "PLAYER_P1" into just "P1"
			-- the end part is all we really need
			local pn = ToEnumShortString(player)
			
			-- get the notefield for this particular player, while we're in the loop
			notefield = SCREENMAN:GetTopScreen():GetChild("Player"..pn):GetChild("NoteField")
			
			-- and pass that player's notefield into the rotation function defined above
			simple_rot_spline_demo(notefield)
		end
    end
}

-- every FGCHANGE or BGCHANGE script in stepmania must return
-- some sort of an Actor, which is a basic StepMania scripting object.
--
-- For more infomation, check out
-- http://dguzek.github.io/Lua-For-SM5/Considerations/Foreword.html
return AF